package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VolumeState {
  def unwrap: software.amazon.awssdk.services.ec2.model.VolumeState
}
object VolumeState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VolumeState
  ): zio.aws.ec2.model.VolumeState = value match {
    case software.amazon.awssdk.services.ec2.model.VolumeState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VolumeState.CREATING =>
      val r = creating
      r
    case software.amazon.awssdk.services.ec2.model.VolumeState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.VolumeState.IN_USE =>
      val r = `in-use`
      r
    case software.amazon.awssdk.services.ec2.model.VolumeState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.ec2.model.VolumeState.DELETED =>
      val r = deleted
      r
    case software.amazon.awssdk.services.ec2.model.VolumeState.ERROR =>
      val r = error
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.VolumeState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VolumeState =
      software.amazon.awssdk.services.ec2.model.VolumeState.UNKNOWN_TO_SDK_VERSION
  }
  case object creating extends zio.aws.ec2.model.VolumeState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VolumeState =
      software.amazon.awssdk.services.ec2.model.VolumeState.CREATING
  }
  case object available extends zio.aws.ec2.model.VolumeState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VolumeState =
      software.amazon.awssdk.services.ec2.model.VolumeState.AVAILABLE
  }
  case object `in-use` extends zio.aws.ec2.model.VolumeState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VolumeState =
      software.amazon.awssdk.services.ec2.model.VolumeState.IN_USE
  }
  case object deleting extends zio.aws.ec2.model.VolumeState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VolumeState =
      software.amazon.awssdk.services.ec2.model.VolumeState.DELETING
  }
  case object deleted extends zio.aws.ec2.model.VolumeState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VolumeState =
      software.amazon.awssdk.services.ec2.model.VolumeState.DELETED
  }
  case object error extends zio.aws.ec2.model.VolumeState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VolumeState =
      software.amazon.awssdk.services.ec2.model.VolumeState.ERROR
  }
}
