package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TransitGatewayMulticastDomainState {
  def unwrap: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainState
}
object TransitGatewayMulticastDomainState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainState
  ): zio.aws.ec2.model.TransitGatewayMulticastDomainState = value match {
    case software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainState.DELETED =>
      val r = deleted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TransitGatewayMulticastDomainState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending
      extends zio.aws.ec2.model.TransitGatewayMulticastDomainState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainState.PENDING
  }
  case object available
      extends zio.aws.ec2.model.TransitGatewayMulticastDomainState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainState.AVAILABLE
  }
  case object deleting
      extends zio.aws.ec2.model.TransitGatewayMulticastDomainState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainState.DELETING
  }
  case object deleted
      extends zio.aws.ec2.model.TransitGatewayMulticastDomainState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainState.DELETED
  }
}
