package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{MillisecondDateTime, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SnapshotInfo(
    description: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    encrypted: Option[Boolean] = None,
    volumeId: Option[String] = None,
    state: Option[zio.aws.ec2.model.SnapshotState] = None,
    volumeSize: Option[Integer] = None,
    startTime: Option[MillisecondDateTime] = None,
    progress: Option[String] = None,
    ownerId: Option[String] = None,
    snapshotId: Option[String] = None,
    outpostArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SnapshotInfo = {
    import SnapshotInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SnapshotInfo
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(volumeId.map(value => value: java.lang.String))(
        _.volumeId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        volumeSize.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.volumeSize)
      .optionallyWith(
        startTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SnapshotInfo.ReadOnly =
    zio.aws.ec2.model.SnapshotInfo.wrap(buildAwsValue())
}
object SnapshotInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.SnapshotInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SnapshotInfo =
      zio.aws.ec2.model.SnapshotInfo(
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        encrypted.map(value => value),
        volumeId.map(value => value),
        state.map(value => value),
        volumeSize.map(value => value),
        startTime.map(value => value),
        progress.map(value => value),
        ownerId.map(value => value),
        snapshotId.map(value => value),
        outpostArn.map(value => value)
      )
    def description: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def encrypted: Option[Boolean]
    def volumeId: Option[String]
    def state: Option[zio.aws.ec2.model.SnapshotState]
    def volumeSize: Option[Integer]
    def startTime: Option[MillisecondDateTime]
    def progress: Option[String]
    def ownerId: Option[String]
    def snapshotId: Option[String]
    def outpostArn: Option[String]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getVolumeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.SnapshotState] =
      AwsError.unwrapOptionField("state", state)
    def getVolumeSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
    def getStartTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progress)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotInfo
  ) extends zio.aws.ec2.model.SnapshotInfo.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val volumeId: Option[String] =
      scala.Option(impl.volumeId()).map(value => value: String)
    override val state: Option[zio.aws.ec2.model.SnapshotState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.SnapshotState.wrap(value))
    override val volumeSize: Option[Integer] = scala
      .Option(impl.volumeSize())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val startTime: Option[MillisecondDateTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val progress: Option[String] =
      scala.Option(impl.progress()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val snapshotId: Option[String] =
      scala.Option(impl.snapshotId()).map(value => value: String)
    override val outpostArn: Option[String] =
      scala.Option(impl.outpostArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotInfo
  ): zio.aws.ec2.model.SnapshotInfo.ReadOnly = new Wrapper(impl)
}
