package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{ScheduledInstanceId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RunScheduledInstancesRequest(
    clientToken: Option[String] = None,
    instanceCount: Option[Integer] = None,
    launchSpecification: zio.aws.ec2.model.ScheduledInstancesLaunchSpecification,
    scheduledInstanceId: ScheduledInstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RunScheduledInstancesRequest = {
    import RunScheduledInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RunScheduledInstancesRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        instanceCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.instanceCount)
      .launchSpecification(launchSpecification.buildAwsValue())
      .scheduledInstanceId(
        ScheduledInstanceId.unwrap(scheduledInstanceId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RunScheduledInstancesRequest.ReadOnly =
    zio.aws.ec2.model.RunScheduledInstancesRequest.wrap(buildAwsValue())
}
object RunScheduledInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RunScheduledInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RunScheduledInstancesRequest =
      zio.aws.ec2.model.RunScheduledInstancesRequest(
        clientToken.map(value => value),
        instanceCount.map(value => value),
        launchSpecification.asEditable,
        scheduledInstanceId
      )
    def clientToken: Option[String]
    def instanceCount: Option[Integer]
    def launchSpecification
        : zio.aws.ec2.model.ScheduledInstancesLaunchSpecification.ReadOnly
    def scheduledInstanceId: ScheduledInstanceId
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getLaunchSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.ScheduledInstancesLaunchSpecification.ReadOnly
    ] = ZIO.succeed(launchSpecification)
    def getScheduledInstanceId: ZIO[Any, Nothing, ScheduledInstanceId] =
      ZIO.succeed(scheduledInstanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RunScheduledInstancesRequest
  ) extends zio.aws.ec2.model.RunScheduledInstancesRequest.ReadOnly {
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val instanceCount: Option[Integer] = scala
      .Option(impl.instanceCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val launchSpecification
        : zio.aws.ec2.model.ScheduledInstancesLaunchSpecification.ReadOnly =
      zio.aws.ec2.model.ScheduledInstancesLaunchSpecification
        .wrap(impl.launchSpecification())
    override val scheduledInstanceId: ScheduledInstanceId =
      zio.aws.ec2.model.primitives
        .ScheduledInstanceId(impl.scheduledInstanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RunScheduledInstancesRequest
  ): zio.aws.ec2.model.RunScheduledInstancesRequest.ReadOnly = new Wrapper(impl)
}
