package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RouteTableAssociation(
    main: Option[Boolean] = None,
    routeTableAssociationId: Option[String] = None,
    routeTableId: Option[String] = None,
    subnetId: Option[String] = None,
    gatewayId: Option[String] = None,
    associationState: Option[zio.aws.ec2.model.RouteTableAssociationState] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RouteTableAssociation = {
    import RouteTableAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RouteTableAssociation
      .builder()
      .optionallyWith(main.map(value => value: java.lang.Boolean))(_.main)
      .optionallyWith(
        routeTableAssociationId.map(value => value: java.lang.String)
      )(_.routeTableAssociationId)
      .optionallyWith(routeTableId.map(value => value: java.lang.String))(
        _.routeTableId
      )
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(gatewayId.map(value => value: java.lang.String))(
        _.gatewayId
      )
      .optionallyWith(associationState.map(value => value.buildAwsValue()))(
        _.associationState
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RouteTableAssociation.ReadOnly =
    zio.aws.ec2.model.RouteTableAssociation.wrap(buildAwsValue())
}
object RouteTableAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RouteTableAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RouteTableAssociation =
      zio.aws.ec2.model.RouteTableAssociation(
        main.map(value => value),
        routeTableAssociationId.map(value => value),
        routeTableId.map(value => value),
        subnetId.map(value => value),
        gatewayId.map(value => value),
        associationState.map(value => value.asEditable)
      )
    def main: Option[Boolean]
    def routeTableAssociationId: Option[String]
    def routeTableId: Option[String]
    def subnetId: Option[String]
    def gatewayId: Option[String]
    def associationState
        : Option[zio.aws.ec2.model.RouteTableAssociationState.ReadOnly]
    def getMain: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("main", main)
    def getRouteTableAssociationId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("routeTableAssociationId", routeTableAssociationId)
    def getRouteTableId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("routeTableId", routeTableId)
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getAssociationState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.RouteTableAssociationState.ReadOnly
    ] = AwsError.unwrapOptionField("associationState", associationState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RouteTableAssociation
  ) extends zio.aws.ec2.model.RouteTableAssociation.ReadOnly {
    override val main: Option[Boolean] =
      scala.Option(impl.main()).map(value => value: Boolean)
    override val routeTableAssociationId: Option[String] =
      scala.Option(impl.routeTableAssociationId()).map(value => value: String)
    override val routeTableId: Option[String] =
      scala.Option(impl.routeTableId()).map(value => value: String)
    override val subnetId: Option[String] =
      scala.Option(impl.subnetId()).map(value => value: String)
    override val gatewayId: Option[String] =
      scala.Option(impl.gatewayId()).map(value => value: String)
    override val associationState
        : Option[zio.aws.ec2.model.RouteTableAssociationState.ReadOnly] = scala
      .Option(impl.associationState())
      .map(value => zio.aws.ec2.model.RouteTableAssociationState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RouteTableAssociation
  ): zio.aws.ec2.model.RouteTableAssociation.ReadOnly = new Wrapper(impl)
}
