package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReservationValue(
    hourlyPrice: Option[String] = None,
    remainingTotalValue: Option[String] = None,
    remainingUpfrontValue: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReservationValue = {
    import ReservationValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReservationValue
      .builder()
      .optionallyWith(hourlyPrice.map(value => value: java.lang.String))(
        _.hourlyPrice
      )
      .optionallyWith(
        remainingTotalValue.map(value => value: java.lang.String)
      )(_.remainingTotalValue)
      .optionallyWith(
        remainingUpfrontValue.map(value => value: java.lang.String)
      )(_.remainingUpfrontValue)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReservationValue.ReadOnly =
    zio.aws.ec2.model.ReservationValue.wrap(buildAwsValue())
}
object ReservationValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReservationValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReservationValue =
      zio.aws.ec2.model.ReservationValue(
        hourlyPrice.map(value => value),
        remainingTotalValue.map(value => value),
        remainingUpfrontValue.map(value => value)
      )
    def hourlyPrice: Option[String]
    def remainingTotalValue: Option[String]
    def remainingUpfrontValue: Option[String]
    def getHourlyPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hourlyPrice", hourlyPrice)
    def getRemainingTotalValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("remainingTotalValue", remainingTotalValue)
    def getRemainingUpfrontValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("remainingUpfrontValue", remainingUpfrontValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReservationValue
  ) extends zio.aws.ec2.model.ReservationValue.ReadOnly {
    override val hourlyPrice: Option[String] =
      scala.Option(impl.hourlyPrice()).map(value => value: String)
    override val remainingTotalValue: Option[String] =
      scala.Option(impl.remainingTotalValue()).map(value => value: String)
    override val remainingUpfrontValue: Option[String] =
      scala.Option(impl.remainingUpfrontValue()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReservationValue
  ): zio.aws.ec2.model.ReservationValue.ReadOnly = new Wrapper(impl)
}
