package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{IpamPoolAllocationId, IpamPoolId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReleaseIpamPoolAllocationRequest(
    ipamPoolId: IpamPoolId,
    cidr: String,
    ipamPoolAllocationId: Option[IpamPoolAllocationId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReleaseIpamPoolAllocationRequest = {
    import ReleaseIpamPoolAllocationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReleaseIpamPoolAllocationRequest
      .builder()
      .ipamPoolId(IpamPoolId.unwrap(ipamPoolId): java.lang.String)
      .cidr(cidr: java.lang.String)
      .optionallyWith(
        ipamPoolAllocationId.map(value =>
          IpamPoolAllocationId.unwrap(value): java.lang.String
        )
      )(_.ipamPoolAllocationId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReleaseIpamPoolAllocationRequest.ReadOnly =
    zio.aws.ec2.model.ReleaseIpamPoolAllocationRequest.wrap(buildAwsValue())
}
object ReleaseIpamPoolAllocationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReleaseIpamPoolAllocationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReleaseIpamPoolAllocationRequest =
      zio.aws.ec2.model.ReleaseIpamPoolAllocationRequest(
        ipamPoolId,
        cidr,
        ipamPoolAllocationId.map(value => value)
      )
    def ipamPoolId: IpamPoolId
    def cidr: String
    def ipamPoolAllocationId: Option[IpamPoolAllocationId]
    def getIpamPoolId: ZIO[Any, Nothing, IpamPoolId] = ZIO.succeed(ipamPoolId)
    def getCidr: ZIO[Any, Nothing, String] = ZIO.succeed(cidr)
    def getIpamPoolAllocationId: ZIO[Any, AwsError, IpamPoolAllocationId] =
      AwsError.unwrapOptionField("ipamPoolAllocationId", ipamPoolAllocationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReleaseIpamPoolAllocationRequest
  ) extends zio.aws.ec2.model.ReleaseIpamPoolAllocationRequest.ReadOnly {
    override val ipamPoolId: IpamPoolId =
      zio.aws.ec2.model.primitives.IpamPoolId(impl.ipamPoolId())
    override val cidr: String = impl.cidr(): String
    override val ipamPoolAllocationId: Option[IpamPoolAllocationId] = scala
      .Option(impl.ipamPoolAllocationId())
      .map(value => zio.aws.ec2.model.primitives.IpamPoolAllocationId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReleaseIpamPoolAllocationRequest
  ): zio.aws.ec2.model.ReleaseIpamPoolAllocationRequest.ReadOnly = new Wrapper(
    impl
  )
}
