package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RegisterInstanceTagAttributeRequest(
    includeAllTagsOfInstance: Option[Boolean] = None,
    instanceTagKeys: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RegisterInstanceTagAttributeRequest = {
    import RegisterInstanceTagAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RegisterInstanceTagAttributeRequest
      .builder()
      .optionallyWith(
        includeAllTagsOfInstance.map(value => value: java.lang.Boolean)
      )(_.includeAllTagsOfInstance)
      .optionallyWith(
        instanceTagKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.instanceTagKeys)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RegisterInstanceTagAttributeRequest.ReadOnly =
    zio.aws.ec2.model.RegisterInstanceTagAttributeRequest.wrap(buildAwsValue())
}
object RegisterInstanceTagAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RegisterInstanceTagAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RegisterInstanceTagAttributeRequest =
      zio.aws.ec2.model.RegisterInstanceTagAttributeRequest(
        includeAllTagsOfInstance.map(value => value),
        instanceTagKeys.map(value => value)
      )
    def includeAllTagsOfInstance: Option[Boolean]
    def instanceTagKeys: Option[List[String]]
    def getIncludeAllTagsOfInstance: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("includeAllTagsOfInstance", includeAllTagsOfInstance)
    def getInstanceTagKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("instanceTagKeys", instanceTagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RegisterInstanceTagAttributeRequest
  ) extends zio.aws.ec2.model.RegisterInstanceTagAttributeRequest.ReadOnly {
    override val includeAllTagsOfInstance: Option[Boolean] =
      scala.Option(impl.includeAllTagsOfInstance()).map(value => value: Boolean)
    override val instanceTagKeys: Option[List[String]] = scala
      .Option(impl.instanceTagKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RegisterInstanceTagAttributeRequest
  ): zio.aws.ec2.model.RegisterInstanceTagAttributeRequest.ReadOnly =
    new Wrapper(impl)
}
