package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyVpnTunnelOptionsResponse(
    vpnConnection: Option[zio.aws.ec2.model.VpnConnection] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsResponse = {
    import ModifyVpnTunnelOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsResponse
      .builder()
      .optionallyWith(vpnConnection.map(value => value.buildAwsValue()))(
        _.vpnConnection
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVpnTunnelOptionsResponse.ReadOnly =
    zio.aws.ec2.model.ModifyVpnTunnelOptionsResponse.wrap(buildAwsValue())
}
object ModifyVpnTunnelOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVpnTunnelOptionsResponse =
      zio.aws.ec2.model.ModifyVpnTunnelOptionsResponse(
        vpnConnection.map(value => value.asEditable)
      )
    def vpnConnection: Option[zio.aws.ec2.model.VpnConnection.ReadOnly]
    def getVpnConnection
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpnConnection.ReadOnly] =
      AwsError.unwrapOptionField("vpnConnection", vpnConnection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsResponse
  ) extends zio.aws.ec2.model.ModifyVpnTunnelOptionsResponse.ReadOnly {
    override val vpnConnection
        : Option[zio.aws.ec2.model.VpnConnection.ReadOnly] = scala
      .Option(impl.vpnConnection())
      .map(value => zio.aws.ec2.model.VpnConnection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsResponse
  ): zio.aws.ec2.model.ModifyVpnTunnelOptionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
