package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyAddressAttributeResponse(
    address: Option[zio.aws.ec2.model.AddressAttribute] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyAddressAttributeResponse = {
    import ModifyAddressAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyAddressAttributeResponse
      .builder()
      .optionallyWith(address.map(value => value.buildAwsValue()))(_.address)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyAddressAttributeResponse.ReadOnly =
    zio.aws.ec2.model.ModifyAddressAttributeResponse.wrap(buildAwsValue())
}
object ModifyAddressAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyAddressAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyAddressAttributeResponse =
      zio.aws.ec2.model
        .ModifyAddressAttributeResponse(address.map(value => value.asEditable))
    def address: Option[zio.aws.ec2.model.AddressAttribute.ReadOnly]
    def getAddress
        : ZIO[Any, AwsError, zio.aws.ec2.model.AddressAttribute.ReadOnly] =
      AwsError.unwrapOptionField("address", address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyAddressAttributeResponse
  ) extends zio.aws.ec2.model.ModifyAddressAttributeResponse.ReadOnly {
    override val address: Option[zio.aws.ec2.model.AddressAttribute.ReadOnly] =
      scala
        .Option(impl.address())
        .map(value => zio.aws.ec2.model.AddressAttribute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyAddressAttributeResponse
  ): zio.aws.ec2.model.ModifyAddressAttributeResponse.ReadOnly = new Wrapper(
    impl
  )
}
