package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IpamResourceTag(
    key: Option[String] = None,
    value: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IpamResourceTag = {
    import IpamResourceTag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpamResourceTag
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpamResourceTag.ReadOnly =
    zio.aws.ec2.model.IpamResourceTag.wrap(buildAwsValue())
}
object IpamResourceTag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IpamResourceTag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpamResourceTag = zio.aws.ec2.model
      .IpamResourceTag(key.map(value => value), value.map(value => value))
    def key: Option[String]
    def value: Option[String]
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpamResourceTag
  ) extends zio.aws.ec2.model.IpamResourceTag.ReadOnly {
    override val key: Option[String] =
      scala.Option(impl.key()).map(value => value: String)
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpamResourceTag
  ): zio.aws.ec2.model.IpamResourceTag.ReadOnly = new Wrapper(impl)
}
