package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{OfferingId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HostOffering(
    currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues] = None,
    duration: Option[Integer] = None,
    hourlyPrice: Option[String] = None,
    instanceFamily: Option[String] = None,
    offeringId: Option[OfferingId] = None,
    paymentOption: Option[zio.aws.ec2.model.PaymentOption] = None,
    upfrontPrice: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.HostOffering = {
    import HostOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.HostOffering
      .builder()
      .optionallyWith(currencyCode.map(value => value.unwrap))(_.currencyCode)
      .optionallyWith(
        duration.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.duration)
      .optionallyWith(hourlyPrice.map(value => value: java.lang.String))(
        _.hourlyPrice
      )
      .optionallyWith(instanceFamily.map(value => value: java.lang.String))(
        _.instanceFamily
      )
      .optionallyWith(
        offeringId.map(value => OfferingId.unwrap(value): java.lang.String)
      )(_.offeringId)
      .optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption)
      .optionallyWith(upfrontPrice.map(value => value: java.lang.String))(
        _.upfrontPrice
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.HostOffering.ReadOnly =
    zio.aws.ec2.model.HostOffering.wrap(buildAwsValue())
}
object HostOffering {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.HostOffering] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.HostOffering =
      zio.aws.ec2.model.HostOffering(
        currencyCode.map(value => value),
        duration.map(value => value),
        hourlyPrice.map(value => value),
        instanceFamily.map(value => value),
        offeringId.map(value => value),
        paymentOption.map(value => value),
        upfrontPrice.map(value => value)
      )
    def currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues]
    def duration: Option[Integer]
    def hourlyPrice: Option[String]
    def instanceFamily: Option[String]
    def offeringId: Option[OfferingId]
    def paymentOption: Option[zio.aws.ec2.model.PaymentOption]
    def upfrontPrice: Option[String]
    def getCurrencyCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.CurrencyCodeValues] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getHourlyPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hourlyPrice", hourlyPrice)
    def getInstanceFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceFamily", instanceFamily)
    def getOfferingId: ZIO[Any, AwsError, OfferingId] =
      AwsError.unwrapOptionField("offeringId", offeringId)
    def getPaymentOption: ZIO[Any, AwsError, zio.aws.ec2.model.PaymentOption] =
      AwsError.unwrapOptionField("paymentOption", paymentOption)
    def getUpfrontPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("upfrontPrice", upfrontPrice)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.HostOffering
  ) extends zio.aws.ec2.model.HostOffering.ReadOnly {
    override val currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues] =
      scala
        .Option(impl.currencyCode())
        .map(value => zio.aws.ec2.model.CurrencyCodeValues.wrap(value))
    override val duration: Option[Integer] = scala
      .Option(impl.duration())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val hourlyPrice: Option[String] =
      scala.Option(impl.hourlyPrice()).map(value => value: String)
    override val instanceFamily: Option[String] =
      scala.Option(impl.instanceFamily()).map(value => value: String)
    override val offeringId: Option[OfferingId] = scala
      .Option(impl.offeringId())
      .map(value => zio.aws.ec2.model.primitives.OfferingId(value))
    override val paymentOption: Option[zio.aws.ec2.model.PaymentOption] = scala
      .Option(impl.paymentOption())
      .map(value => zio.aws.ec2.model.PaymentOption.wrap(value))
    override val upfrontPrice: Option[String] =
      scala.Option(impl.upfrontPrice()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.HostOffering
  ): zio.aws.ec2.model.HostOffering.ReadOnly = new Wrapper(impl)
}
