package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HostInstance(
    instanceId: Option[String] = None,
    instanceType: Option[String] = None,
    ownerId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.HostInstance = {
    import HostInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.HostInstance
      .builder()
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.HostInstance.ReadOnly =
    zio.aws.ec2.model.HostInstance.wrap(buildAwsValue())
}
object HostInstance {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.HostInstance] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.HostInstance =
      zio.aws.ec2.model.HostInstance(
        instanceId.map(value => value),
        instanceType.map(value => value),
        ownerId.map(value => value)
      )
    def instanceId: Option[String]
    def instanceType: Option[String]
    def ownerId: Option[String]
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.HostInstance
  ) extends zio.aws.ec2.model.HostInstance.ReadOnly {
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val instanceType: Option[String] =
      scala.Option(impl.instanceType()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.HostInstance
  ): zio.aws.ec2.model.HostInstance.ReadOnly = new Wrapper(impl)
}
