package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetLaunchTemplateDataResponse(
    launchTemplateData: Option[zio.aws.ec2.model.ResponseLaunchTemplateData] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataResponse = {
    import GetLaunchTemplateDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataResponse
      .builder()
      .optionallyWith(launchTemplateData.map(value => value.buildAwsValue()))(
        _.launchTemplateData
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetLaunchTemplateDataResponse.ReadOnly =
    zio.aws.ec2.model.GetLaunchTemplateDataResponse.wrap(buildAwsValue())
}
object GetLaunchTemplateDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetLaunchTemplateDataResponse =
      zio.aws.ec2.model.GetLaunchTemplateDataResponse(
        launchTemplateData.map(value => value.asEditable)
      )
    def launchTemplateData
        : Option[zio.aws.ec2.model.ResponseLaunchTemplateData.ReadOnly]
    def getLaunchTemplateData: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ResponseLaunchTemplateData.ReadOnly
    ] = AwsError.unwrapOptionField("launchTemplateData", launchTemplateData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataResponse
  ) extends zio.aws.ec2.model.GetLaunchTemplateDataResponse.ReadOnly {
    override val launchTemplateData
        : Option[zio.aws.ec2.model.ResponseLaunchTemplateData.ReadOnly] = scala
      .Option(impl.launchTemplateData())
      .map(value => zio.aws.ec2.model.ResponseLaunchTemplateData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataResponse
  ): zio.aws.ec2.model.GetLaunchTemplateDataResponse.ReadOnly = new Wrapper(
    impl
  )
}
