package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExportTaskS3Location(
    s3Bucket: Option[String] = None,
    s3Prefix: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ExportTaskS3Location = {
    import ExportTaskS3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ExportTaskS3Location
      .builder()
      .optionallyWith(s3Bucket.map(value => value: java.lang.String))(
        _.s3Bucket
      )
      .optionallyWith(s3Prefix.map(value => value: java.lang.String))(
        _.s3Prefix
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ExportTaskS3Location.ReadOnly =
    zio.aws.ec2.model.ExportTaskS3Location.wrap(buildAwsValue())
}
object ExportTaskS3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ExportTaskS3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ExportTaskS3Location =
      zio.aws.ec2.model.ExportTaskS3Location(
        s3Bucket.map(value => value),
        s3Prefix.map(value => value)
      )
    def s3Bucket: Option[String]
    def s3Prefix: Option[String]
    def getS3Bucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Prefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Prefix", s3Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ExportTaskS3Location
  ) extends zio.aws.ec2.model.ExportTaskS3Location.ReadOnly {
    override val s3Bucket: Option[String] =
      scala.Option(impl.s3Bucket()).map(value => value: String)
    override val s3Prefix: Option[String] =
      scala.Option(impl.s3Prefix()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ExportTaskS3Location
  ): zio.aws.ec2.model.ExportTaskS3Location.ReadOnly = new Wrapper(impl)
}
