package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.EgressOnlyInternetGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EgressOnlyInternetGateway(
    attachments: Option[Iterable[zio.aws.ec2.model.InternetGatewayAttachment]] =
      None,
    egressOnlyInternetGatewayId: Option[EgressOnlyInternetGatewayId] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGateway = {
    import EgressOnlyInternetGateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGateway
      .builder()
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .optionallyWith(
        egressOnlyInternetGatewayId.map(value =>
          EgressOnlyInternetGatewayId.unwrap(value): java.lang.String
        )
      )(_.egressOnlyInternetGatewayId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EgressOnlyInternetGateway.ReadOnly =
    zio.aws.ec2.model.EgressOnlyInternetGateway.wrap(buildAwsValue())
}
object EgressOnlyInternetGateway {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGateway
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EgressOnlyInternetGateway =
      zio.aws.ec2.model.EgressOnlyInternetGateway(
        attachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        egressOnlyInternetGatewayId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attachments
        : Option[List[zio.aws.ec2.model.InternetGatewayAttachment.ReadOnly]]
    def egressOnlyInternetGatewayId: Option[EgressOnlyInternetGatewayId]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getAttachments: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InternetGatewayAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField("attachments", attachments)
    def getEgressOnlyInternetGatewayId
        : ZIO[Any, AwsError, EgressOnlyInternetGatewayId] =
      AwsError.unwrapOptionField(
        "egressOnlyInternetGatewayId",
        egressOnlyInternetGatewayId
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGateway
  ) extends zio.aws.ec2.model.EgressOnlyInternetGateway.ReadOnly {
    override val attachments
        : Option[List[zio.aws.ec2.model.InternetGatewayAttachment.ReadOnly]] =
      scala
        .Option(impl.attachments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InternetGatewayAttachment.wrap(item)
          }.toList
        )
    override val egressOnlyInternetGatewayId
        : Option[EgressOnlyInternetGatewayId] = scala
      .Option(impl.egressOnlyInternetGatewayId())
      .map(value =>
        zio.aws.ec2.model.primitives.EgressOnlyInternetGatewayId(value)
      )
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGateway
  ): zio.aws.ec2.model.EgressOnlyInternetGateway.ReadOnly = new Wrapper(impl)
}
