package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisassociateVpcCidrBlockResponse(
    ipv6CidrBlockAssociation: Option[
      zio.aws.ec2.model.VpcIpv6CidrBlockAssociation
    ] = None,
    cidrBlockAssociation: Option[zio.aws.ec2.model.VpcCidrBlockAssociation] =
      None,
    vpcId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockResponse = {
    import DisassociateVpcCidrBlockResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockResponse
      .builder()
      .optionallyWith(
        ipv6CidrBlockAssociation.map(value => value.buildAwsValue())
      )(_.ipv6CidrBlockAssociation)
      .optionallyWith(cidrBlockAssociation.map(value => value.buildAwsValue()))(
        _.cidrBlockAssociation
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DisassociateVpcCidrBlockResponse.ReadOnly =
    zio.aws.ec2.model.DisassociateVpcCidrBlockResponse.wrap(buildAwsValue())
}
object DisassociateVpcCidrBlockResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisassociateVpcCidrBlockResponse =
      zio.aws.ec2.model.DisassociateVpcCidrBlockResponse(
        ipv6CidrBlockAssociation.map(value => value.asEditable),
        cidrBlockAssociation.map(value => value.asEditable),
        vpcId.map(value => value)
      )
    def ipv6CidrBlockAssociation
        : Option[zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.ReadOnly]
    def cidrBlockAssociation
        : Option[zio.aws.ec2.model.VpcCidrBlockAssociation.ReadOnly]
    def vpcId: Option[String]
    def getIpv6CidrBlockAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ipv6CidrBlockAssociation",
      ipv6CidrBlockAssociation
    )
    def getCidrBlockAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VpcCidrBlockAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("cidrBlockAssociation", cidrBlockAssociation)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockResponse
  ) extends zio.aws.ec2.model.DisassociateVpcCidrBlockResponse.ReadOnly {
    override val ipv6CidrBlockAssociation
        : Option[zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.ReadOnly] = scala
      .Option(impl.ipv6CidrBlockAssociation())
      .map(value => zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.wrap(value))
    override val cidrBlockAssociation
        : Option[zio.aws.ec2.model.VpcCidrBlockAssociation.ReadOnly] = scala
      .Option(impl.cidrBlockAssociation())
      .map(value => zio.aws.ec2.model.VpcCidrBlockAssociation.wrap(value))
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockResponse
  ): zio.aws.ec2.model.DisassociateVpcCidrBlockResponse.ReadOnly = new Wrapper(
    impl
  )
}
