package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceEventWindowId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateInstanceEventWindowRequest(
    instanceEventWindowId: InstanceEventWindowId,
    associationTarget: zio.aws.ec2.model.InstanceEventWindowDisassociationRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowRequest = {
    import DisassociateInstanceEventWindowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowRequest
      .builder()
      .instanceEventWindowId(
        InstanceEventWindowId.unwrap(instanceEventWindowId): java.lang.String
      )
      .associationTarget(associationTarget.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateInstanceEventWindowRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateInstanceEventWindowRequest
      .wrap(buildAwsValue())
}
object DisassociateInstanceEventWindowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisassociateInstanceEventWindowRequest =
      zio.aws.ec2.model.DisassociateInstanceEventWindowRequest(
        instanceEventWindowId,
        associationTarget.asEditable
      )
    def instanceEventWindowId: InstanceEventWindowId
    def associationTarget
        : zio.aws.ec2.model.InstanceEventWindowDisassociationRequest.ReadOnly
    def getInstanceEventWindowId: ZIO[Any, Nothing, InstanceEventWindowId] =
      ZIO.succeed(instanceEventWindowId)
    def getAssociationTarget: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.InstanceEventWindowDisassociationRequest.ReadOnly
    ] = ZIO.succeed(associationTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowRequest
  ) extends zio.aws.ec2.model.DisassociateInstanceEventWindowRequest.ReadOnly {
    override val instanceEventWindowId: InstanceEventWindowId =
      zio.aws.ec2.model.primitives
        .InstanceEventWindowId(impl.instanceEventWindowId())
    override val associationTarget
        : zio.aws.ec2.model.InstanceEventWindowDisassociationRequest.ReadOnly =
      zio.aws.ec2.model.InstanceEventWindowDisassociationRequest
        .wrap(impl.associationTarget())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowRequest
  ): zio.aws.ec2.model.DisassociateInstanceEventWindowRequest.ReadOnly =
    new Wrapper(impl)
}
