package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisableTransitGatewayRouteTablePropagationResponse(
    propagation: Option[zio.aws.ec2.model.TransitGatewayPropagation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationResponse = {
    import DisableTransitGatewayRouteTablePropagationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationResponse
      .builder()
      .optionallyWith(propagation.map(value => value.buildAwsValue()))(
        _.propagation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationResponse.ReadOnly =
    zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationResponse
      .wrap(buildAwsValue())
}
object DisableTransitGatewayRouteTablePropagationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationResponse =
      zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationResponse(
        propagation.map(value => value.asEditable)
      )
    def propagation
        : Option[zio.aws.ec2.model.TransitGatewayPropagation.ReadOnly]
    def getPropagation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPropagation.ReadOnly
    ] = AwsError.unwrapOptionField("propagation", propagation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationResponse
  ) extends zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationResponse.ReadOnly {
    override val propagation
        : Option[zio.aws.ec2.model.TransitGatewayPropagation.ReadOnly] = scala
      .Option(impl.propagation())
      .map(value => zio.aws.ec2.model.TransitGatewayPropagation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationResponse
  ): zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationResponse.ReadOnly =
    new Wrapper(impl)
}
