package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VolumeId, InstanceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DetachVolumeRequest(
    device: Option[String] = None,
    force: Option[Boolean] = None,
    instanceId: Option[InstanceId] = None,
    volumeId: VolumeId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DetachVolumeRequest = {
    import DetachVolumeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DetachVolumeRequest
      .builder()
      .optionallyWith(device.map(value => value: java.lang.String))(_.device)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .volumeId(VolumeId.unwrap(volumeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DetachVolumeRequest.ReadOnly =
    zio.aws.ec2.model.DetachVolumeRequest.wrap(buildAwsValue())
}
object DetachVolumeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DetachVolumeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DetachVolumeRequest =
      zio.aws.ec2.model.DetachVolumeRequest(
        device.map(value => value),
        force.map(value => value),
        instanceId.map(value => value),
        volumeId
      )
    def device: Option[String]
    def force: Option[Boolean]
    def instanceId: Option[InstanceId]
    def volumeId: VolumeId
    def getDevice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("device", device)
    def getForce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", force)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getVolumeId: ZIO[Any, Nothing, VolumeId] = ZIO.succeed(volumeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DetachVolumeRequest
  ) extends zio.aws.ec2.model.DetachVolumeRequest.ReadOnly {
    override val device: Option[String] =
      scala.Option(impl.device()).map(value => value: String)
    override val force: Option[Boolean] =
      scala.Option(impl.force()).map(value => value: Boolean)
    override val instanceId: Option[InstanceId] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.ec2.model.primitives.InstanceId(value))
    override val volumeId: VolumeId =
      zio.aws.ec2.model.primitives.VolumeId(impl.volumeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DetachVolumeRequest
  ): zio.aws.ec2.model.DetachVolumeRequest.ReadOnly = new Wrapper(impl)
}
