package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSpotInstanceRequestsResponse(
    spotInstanceRequests: Option[
      Iterable[zio.aws.ec2.model.SpotInstanceRequest]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse = {
    import DescribeSpotInstanceRequestsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse
      .builder()
      .optionallyWith(
        spotInstanceRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.spotInstanceRequests)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeSpotInstanceRequestsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeSpotInstanceRequestsResponse.wrap(buildAwsValue())
}
object DescribeSpotInstanceRequestsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSpotInstanceRequestsResponse =
      zio.aws.ec2.model.DescribeSpotInstanceRequestsResponse(
        spotInstanceRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def spotInstanceRequests
        : Option[List[zio.aws.ec2.model.SpotInstanceRequest.ReadOnly]]
    def nextToken: Option[String]
    def getSpotInstanceRequests: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SpotInstanceRequest.ReadOnly
    ]] =
      AwsError.unwrapOptionField("spotInstanceRequests", spotInstanceRequests)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse
  ) extends zio.aws.ec2.model.DescribeSpotInstanceRequestsResponse.ReadOnly {
    override val spotInstanceRequests
        : Option[List[zio.aws.ec2.model.SpotInstanceRequest.ReadOnly]] = scala
      .Option(impl.spotInstanceRequests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SpotInstanceRequest.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse
  ): zio.aws.ec2.model.DescribeSpotInstanceRequestsResponse.ReadOnly =
    new Wrapper(impl)
}
