package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  DescribeRouteTablesMaxResults,
  RouteTableId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeRouteTablesRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    routeTableIds: Option[Iterable[RouteTableId]] = None,
    nextToken: Option[String] = None,
    maxResults: Option[DescribeRouteTablesMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeRouteTablesRequest = {
    import DescribeRouteTablesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeRouteTablesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        routeTableIds.map(value =>
          value.map { item =>
            RouteTableId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.routeTableIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeRouteTablesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeRouteTablesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeRouteTablesRequest.wrap(buildAwsValue())
}
object DescribeRouteTablesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeRouteTablesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeRouteTablesRequest =
      zio.aws.ec2.model.DescribeRouteTablesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        routeTableIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def routeTableIds: Option[List[RouteTableId]]
    def nextToken: Option[String]
    def maxResults: Option[DescribeRouteTablesMaxResults]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getRouteTableIds: ZIO[Any, AwsError, List[RouteTableId]] =
      AwsError.unwrapOptionField("routeTableIds", routeTableIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DescribeRouteTablesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeRouteTablesRequest
  ) extends zio.aws.ec2.model.DescribeRouteTablesRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val routeTableIds: Option[List[RouteTableId]] = scala
      .Option(impl.routeTableIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.RouteTableId(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[DescribeRouteTablesMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.DescribeRouteTablesMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeRouteTablesRequest
  ): zio.aws.ec2.model.DescribeRouteTablesRequest.ReadOnly = new Wrapper(impl)
}
