package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{PrefixListResourceId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribePrefixListsRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None,
    prefixListIds: Option[Iterable[PrefixListResourceId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest = {
    import DescribePrefixListsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        prefixListIds.map(value =>
          value.map { item =>
            PrefixListResourceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.prefixListIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribePrefixListsRequest.ReadOnly =
    zio.aws.ec2.model.DescribePrefixListsRequest.wrap(buildAwsValue())
}
object DescribePrefixListsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribePrefixListsRequest =
      zio.aws.ec2.model.DescribePrefixListsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        prefixListIds.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def prefixListIds: Option[List[PrefixListResourceId]]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPrefixListIds: ZIO[Any, AwsError, List[PrefixListResourceId]] =
      AwsError.unwrapOptionField("prefixListIds", prefixListIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest
  ) extends zio.aws.ec2.model.DescribePrefixListsRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val prefixListIds: Option[List[PrefixListResourceId]] = scala
      .Option(impl.prefixListIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.PrefixListResourceId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest
  ): zio.aws.ec2.model.DescribePrefixListsRequest.ReadOnly = new Wrapper(impl)
}
