package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  DescribeNetworkAclsMaxResults,
  NetworkAclId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeNetworkAclsRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    networkAclIds: Option[Iterable[NetworkAclId]] = None,
    nextToken: Option[String] = None,
    maxResults: Option[DescribeNetworkAclsMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest = {
    import DescribeNetworkAclsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        networkAclIds.map(value =>
          value.map { item =>
            NetworkAclId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.networkAclIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeNetworkAclsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeNetworkAclsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkAclsRequest.wrap(buildAwsValue())
}
object DescribeNetworkAclsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeNetworkAclsRequest =
      zio.aws.ec2.model.DescribeNetworkAclsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkAclIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def networkAclIds: Option[List[NetworkAclId]]
    def nextToken: Option[String]
    def maxResults: Option[DescribeNetworkAclsMaxResults]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNetworkAclIds: ZIO[Any, AwsError, List[NetworkAclId]] =
      AwsError.unwrapOptionField("networkAclIds", networkAclIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DescribeNetworkAclsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest
  ) extends zio.aws.ec2.model.DescribeNetworkAclsRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val networkAclIds: Option[List[NetworkAclId]] = scala
      .Option(impl.networkAclIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.NetworkAclId(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[DescribeNetworkAclsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.DescribeNetworkAclsMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest
  ): zio.aws.ec2.model.DescribeNetworkAclsRequest.ReadOnly = new Wrapper(impl)
}
