package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  NextToken,
  DescribeIamInstanceProfileAssociationsMaxResults,
  IamInstanceProfileAssociationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeIamInstanceProfileAssociationsRequest(
    associationIds: Option[Iterable[IamInstanceProfileAssociationId]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[DescribeIamInstanceProfileAssociationsMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest = {
    import DescribeIamInstanceProfileAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest
      .builder()
      .optionallyWith(
        associationIds.map(value =>
          value.map { item =>
            IamInstanceProfileAssociationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.associationIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          DescribeIamInstanceProfileAssociationsMaxResults.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeIamInstanceProfileAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsRequest =
      zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsRequest(
        associationIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def associationIds: Option[List[IamInstanceProfileAssociationId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[DescribeIamInstanceProfileAssociationsMaxResults]
    def nextToken: Option[NextToken]
    def getAssociationIds
        : ZIO[Any, AwsError, List[IamInstanceProfileAssociationId]] =
      AwsError.unwrapOptionField("associationIds", associationIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeIamInstanceProfileAssociationsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest
  ) extends zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsRequest.ReadOnly {
    override val associationIds: Option[List[IamInstanceProfileAssociationId]] =
      scala
        .Option(impl.associationIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.IamInstanceProfileAssociationId(item)
          }.toList
        )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults
        : Option[DescribeIamInstanceProfileAssociationsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives
          .DescribeIamInstanceProfileAssociationsMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest
  ): zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
