package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  DescribeCapacityReservationsMaxResults,
  CapacityReservationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeCapacityReservationsRequest(
    capacityReservationIds: Option[Iterable[CapacityReservationId]] = None,
    nextToken: Option[String] = None,
    maxResults: Option[DescribeCapacityReservationsMaxResults] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest = {
    import DescribeCapacityReservationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest
      .builder()
      .optionallyWith(
        capacityReservationIds.map(value =>
          value.map { item =>
            CapacityReservationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.capacityReservationIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeCapacityReservationsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeCapacityReservationsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeCapacityReservationsRequest.wrap(buildAwsValue())
}
object DescribeCapacityReservationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeCapacityReservationsRequest =
      zio.aws.ec2.model.DescribeCapacityReservationsRequest(
        capacityReservationIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def capacityReservationIds: Option[List[CapacityReservationId]]
    def nextToken: Option[String]
    def maxResults: Option[DescribeCapacityReservationsMaxResults]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getCapacityReservationIds
        : ZIO[Any, AwsError, List[CapacityReservationId]] = AwsError
      .unwrapOptionField("capacityReservationIds", capacityReservationIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeCapacityReservationsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest
  ) extends zio.aws.ec2.model.DescribeCapacityReservationsRequest.ReadOnly {
    override val capacityReservationIds: Option[List[CapacityReservationId]] =
      scala
        .Option(impl.capacityReservationIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.CapacityReservationId(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[DescribeCapacityReservationsMaxResults] =
      scala
        .Option(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeCapacityReservationsMaxResults(value)
        )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest
  ): zio.aws.ec2.model.DescribeCapacityReservationsRequest.ReadOnly =
    new Wrapper(impl)
}
