package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAvailabilityZonesResponse(
    availabilityZones: Option[Iterable[zio.aws.ec2.model.AvailabilityZone]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesResponse = {
    import DescribeAvailabilityZonesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesResponse
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeAvailabilityZonesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeAvailabilityZonesResponse.wrap(buildAwsValue())
}
object DescribeAvailabilityZonesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeAvailabilityZonesResponse =
      zio.aws.ec2.model.DescribeAvailabilityZonesResponse(
        availabilityZones.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def availabilityZones
        : Option[List[zio.aws.ec2.model.AvailabilityZone.ReadOnly]]
    def getAvailabilityZones: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AvailabilityZone.ReadOnly
    ]] = AwsError.unwrapOptionField("availabilityZones", availabilityZones)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesResponse
  ) extends zio.aws.ec2.model.DescribeAvailabilityZonesResponse.ReadOnly {
    override val availabilityZones
        : Option[List[zio.aws.ec2.model.AvailabilityZone.ReadOnly]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AvailabilityZone.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesResponse
  ): zio.aws.ec2.model.DescribeAvailabilityZonesResponse.ReadOnly = new Wrapper(
    impl
  )
}
