package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamPoolId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeprovisionIpamPoolCidrRequest(
    ipamPoolId: IpamPoolId,
    cidr: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrRequest = {
    import DeprovisionIpamPoolCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrRequest
      .builder()
      .ipamPoolId(IpamPoolId.unwrap(ipamPoolId): java.lang.String)
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeprovisionIpamPoolCidrRequest.ReadOnly =
    zio.aws.ec2.model.DeprovisionIpamPoolCidrRequest.wrap(buildAwsValue())
}
object DeprovisionIpamPoolCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeprovisionIpamPoolCidrRequest =
      zio.aws.ec2.model
        .DeprovisionIpamPoolCidrRequest(ipamPoolId, cidr.map(value => value))
    def ipamPoolId: IpamPoolId
    def cidr: Option[String]
    def getIpamPoolId: ZIO[Any, Nothing, IpamPoolId] = ZIO.succeed(ipamPoolId)
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrRequest
  ) extends zio.aws.ec2.model.DeprovisionIpamPoolCidrRequest.ReadOnly {
    override val ipamPoolId: IpamPoolId =
      zio.aws.ec2.model.primitives.IpamPoolId(impl.ipamPoolId())
    override val cidr: Option[String] =
      scala.Option(impl.cidr()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrRequest
  ): zio.aws.ec2.model.DeprovisionIpamPoolCidrRequest.ReadOnly = new Wrapper(
    impl
  )
}
