package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TrafficMirrorSessionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteTrafficMirrorSessionRequest(
    trafficMirrorSessionId: TrafficMirrorSessionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionRequest = {
    import DeleteTrafficMirrorSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionRequest
      .builder()
      .trafficMirrorSessionId(
        TrafficMirrorSessionId.unwrap(trafficMirrorSessionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteTrafficMirrorSessionRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTrafficMirrorSessionRequest.wrap(buildAwsValue())
}
object DeleteTrafficMirrorSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTrafficMirrorSessionRequest =
      zio.aws.ec2.model
        .DeleteTrafficMirrorSessionRequest(trafficMirrorSessionId)
    def trafficMirrorSessionId: TrafficMirrorSessionId
    def getTrafficMirrorSessionId: ZIO[Any, Nothing, TrafficMirrorSessionId] =
      ZIO.succeed(trafficMirrorSessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionRequest
  ) extends zio.aws.ec2.model.DeleteTrafficMirrorSessionRequest.ReadOnly {
    override val trafficMirrorSessionId: TrafficMirrorSessionId =
      zio.aws.ec2.model.primitives
        .TrafficMirrorSessionId(impl.trafficMirrorSessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionRequest
  ): zio.aws.ec2.model.DeleteTrafficMirrorSessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
