package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteIpamResponse(
    ipam: Option[zio.aws.ec2.model.Ipam] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteIpamResponse = {
    import DeleteIpamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteIpamResponse
      .builder()
      .optionallyWith(ipam.map(value => value.buildAwsValue()))(_.ipam)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteIpamResponse.ReadOnly =
    zio.aws.ec2.model.DeleteIpamResponse.wrap(buildAwsValue())
}
object DeleteIpamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteIpamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteIpamResponse =
      zio.aws.ec2.model.DeleteIpamResponse(ipam.map(value => value.asEditable))
    def ipam: Option[zio.aws.ec2.model.Ipam.ReadOnly]
    def getIpam: ZIO[Any, AwsError, zio.aws.ec2.model.Ipam.ReadOnly] =
      AwsError.unwrapOptionField("ipam", ipam)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamResponse
  ) extends zio.aws.ec2.model.DeleteIpamResponse.ReadOnly {
    override val ipam: Option[zio.aws.ec2.model.Ipam.ReadOnly] =
      scala.Option(impl.ipam()).map(value => zio.aws.ec2.model.Ipam.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamResponse
  ): zio.aws.ec2.model.DeleteIpamResponse.ReadOnly = new Wrapper(impl)
}
