package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteFleetError(
    code: Option[zio.aws.ec2.model.DeleteFleetErrorCode] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteFleetError = {
    import DeleteFleetError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteFleetError
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteFleetError.ReadOnly =
    zio.aws.ec2.model.DeleteFleetError.wrap(buildAwsValue())
}
object DeleteFleetError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteFleetError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteFleetError = zio.aws.ec2.model
      .DeleteFleetError(code.map(value => value), message.map(value => value))
    def code: Option[zio.aws.ec2.model.DeleteFleetErrorCode]
    def message: Option[String]
    def getCode: ZIO[Any, AwsError, zio.aws.ec2.model.DeleteFleetErrorCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteFleetError
  ) extends zio.aws.ec2.model.DeleteFleetError.ReadOnly {
    override val code: Option[zio.aws.ec2.model.DeleteFleetErrorCode] = scala
      .Option(impl.code())
      .map(value => zio.aws.ec2.model.DeleteFleetErrorCode.wrap(value))
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteFleetError
  ): zio.aws.ec2.model.DeleteFleetError.ReadOnly = new Wrapper(impl)
}
