package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSubnetRequest(
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    availabilityZone: Option[String] = None,
    availabilityZoneId: Option[String] = None,
    cidrBlock: Option[String] = None,
    ipv6CidrBlock: Option[String] = None,
    outpostArn: Option[String] = None,
    vpcId: VpcId,
    ipv6Native: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateSubnetRequest = {
    import CreateSubnetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateSubnetRequest
      .builder()
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(availabilityZoneId.map(value => value: java.lang.String))(
        _.availabilityZoneId
      )
      .optionallyWith(cidrBlock.map(value => value: java.lang.String))(
        _.cidrBlock
      )
      .optionallyWith(ipv6CidrBlock.map(value => value: java.lang.String))(
        _.ipv6CidrBlock
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .optionallyWith(ipv6Native.map(value => value: java.lang.Boolean))(
        _.ipv6Native
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateSubnetRequest.ReadOnly =
    zio.aws.ec2.model.CreateSubnetRequest.wrap(buildAwsValue())
}
object CreateSubnetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateSubnetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateSubnetRequest =
      zio.aws.ec2.model.CreateSubnetRequest(
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZone.map(value => value),
        availabilityZoneId.map(value => value),
        cidrBlock.map(value => value),
        ipv6CidrBlock.map(value => value),
        outpostArn.map(value => value),
        vpcId,
        ipv6Native.map(value => value)
      )
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def availabilityZone: Option[String]
    def availabilityZoneId: Option[String]
    def cidrBlock: Option[String]
    def ipv6CidrBlock: Option[String]
    def outpostArn: Option[String]
    def vpcId: VpcId
    def ipv6Native: Option[Boolean]
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAvailabilityZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getIpv6CidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6CidrBlock", ipv6CidrBlock)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getIpv6Native: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ipv6Native", ipv6Native)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateSubnetRequest
  ) extends zio.aws.ec2.model.CreateSubnetRequest.ReadOnly {
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val availabilityZoneId: Option[String] =
      scala.Option(impl.availabilityZoneId()).map(value => value: String)
    override val cidrBlock: Option[String] =
      scala.Option(impl.cidrBlock()).map(value => value: String)
    override val ipv6CidrBlock: Option[String] =
      scala.Option(impl.ipv6CidrBlock()).map(value => value: String)
    override val outpostArn: Option[String] =
      scala.Option(impl.outpostArn()).map(value => value: String)
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
    override val ipv6Native: Option[Boolean] =
      scala.Option(impl.ipv6Native()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateSubnetRequest
  ): zio.aws.ec2.model.CreateSubnetRequest.ReadOnly = new Wrapper(impl)
}
