package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait BurstablePerformance {
  def unwrap: software.amazon.awssdk.services.ec2.model.BurstablePerformance
}
object BurstablePerformance {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.BurstablePerformance
  ): zio.aws.ec2.model.BurstablePerformance = value match {
    case software.amazon.awssdk.services.ec2.model.BurstablePerformance.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.BurstablePerformance.INCLUDED =>
      val r = included
      r
    case software.amazon.awssdk.services.ec2.model.BurstablePerformance.REQUIRED =>
      val r = required
      r
    case software.amazon.awssdk.services.ec2.model.BurstablePerformance.EXCLUDED =>
      val r = excluded
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.BurstablePerformance {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BurstablePerformance =
      software.amazon.awssdk.services.ec2.model.BurstablePerformance.UNKNOWN_TO_SDK_VERSION
  }
  case object included extends zio.aws.ec2.model.BurstablePerformance {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BurstablePerformance =
      software.amazon.awssdk.services.ec2.model.BurstablePerformance.INCLUDED
  }
  case object required extends zio.aws.ec2.model.BurstablePerformance {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BurstablePerformance =
      software.amazon.awssdk.services.ec2.model.BurstablePerformance.REQUIRED
  }
  case object excluded extends zio.aws.ec2.model.BurstablePerformance {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BurstablePerformance =
      software.amazon.awssdk.services.ec2.model.BurstablePerformance.EXCLUDED
  }
}
