package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayAttachmentId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransitGatewayPropagation(
    transitGatewayAttachmentId: Option[TransitGatewayAttachmentId] = None,
    resourceId: Option[String] = None,
    resourceType: Option[
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = None,
    transitGatewayRouteTableId: Option[String] = None,
    state: Option[zio.aws.ec2.model.TransitGatewayPropagationState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayPropagation = {
    import TransitGatewayPropagation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayPropagation
      .builder()
      .optionallyWith(
        transitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentId)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        transitGatewayRouteTableId.map(value => value: java.lang.String)
      )(_.transitGatewayRouteTableId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayPropagation.ReadOnly =
    zio.aws.ec2.model.TransitGatewayPropagation.wrap(buildAwsValue())
}
object TransitGatewayPropagation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayPropagation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayPropagation =
      zio.aws.ec2.model.TransitGatewayPropagation(
        transitGatewayAttachmentId.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value),
        transitGatewayRouteTableId.map(value => value),
        state.map(value => value)
      )
    def transitGatewayAttachmentId: Option[TransitGatewayAttachmentId]
    def resourceId: Option[String]
    def resourceType
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentResourceType]
    def transitGatewayRouteTableId: Option[String]
    def state: Option[zio.aws.ec2.model.TransitGatewayPropagationState]
    def getTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getTransitGatewayRouteTableId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTableId",
        transitGatewayRouteTableId
      )
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayPropagationState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPropagation
  ) extends zio.aws.ec2.model.TransitGatewayPropagation.ReadOnly {
    override val transitGatewayAttachmentId
        : Option[TransitGatewayAttachmentId] = scala
      .Option(impl.transitGatewayAttachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
      )
    override val resourceId: Option[String] =
      scala.Option(impl.resourceId()).map(value => value: String)
    override val resourceType
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayAttachmentResourceType.wrap(value)
      )
    override val transitGatewayRouteTableId: Option[String] = scala
      .Option(impl.transitGatewayRouteTableId())
      .map(value => value: String)
    override val state
        : Option[zio.aws.ec2.model.TransitGatewayPropagationState] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayPropagationState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPropagation
  ): zio.aws.ec2.model.TransitGatewayPropagation.ReadOnly = new Wrapper(impl)
}
