package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TransitGateway(
    transitGatewayId: Option[String] = None,
    transitGatewayArn: Option[String] = None,
    state: Option[zio.aws.ec2.model.TransitGatewayState] = None,
    ownerId: Option[String] = None,
    description: Option[String] = None,
    creationTime: Option[DateTime] = None,
    options: Option[zio.aws.ec2.model.TransitGatewayOptions] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGateway = {
    import TransitGateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGateway
      .builder()
      .optionallyWith(transitGatewayId.map(value => value: java.lang.String))(
        _.transitGatewayId
      )
      .optionallyWith(transitGatewayArn.map(value => value: java.lang.String))(
        _.transitGatewayArn
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGateway.ReadOnly =
    zio.aws.ec2.model.TransitGateway.wrap(buildAwsValue())
}
object TransitGateway {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGateway
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGateway =
      zio.aws.ec2.model.TransitGateway(
        transitGatewayId.map(value => value),
        transitGatewayArn.map(value => value),
        state.map(value => value),
        ownerId.map(value => value),
        description.map(value => value),
        creationTime.map(value => value),
        options.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayId: Option[String]
    def transitGatewayArn: Option[String]
    def state: Option[zio.aws.ec2.model.TransitGatewayState]
    def ownerId: Option[String]
    def description: Option[String]
    def creationTime: Option[DateTime]
    def options: Option[zio.aws.ec2.model.TransitGatewayOptions.ReadOnly]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTransitGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getTransitGatewayArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayArn", transitGatewayArn)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayState] =
      AwsError.unwrapOptionField("state", state)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayOptions.ReadOnly] =
      AwsError.unwrapOptionField("options", options)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGateway
  ) extends zio.aws.ec2.model.TransitGateway.ReadOnly {
    override val transitGatewayId: Option[String] =
      scala.Option(impl.transitGatewayId()).map(value => value: String)
    override val transitGatewayArn: Option[String] =
      scala.Option(impl.transitGatewayArn()).map(value => value: String)
    override val state: Option[zio.aws.ec2.model.TransitGatewayState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.TransitGatewayState.wrap(value))
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val creationTime: Option[DateTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val options
        : Option[zio.aws.ec2.model.TransitGatewayOptions.ReadOnly] = scala
      .Option(impl.options())
      .map(value => zio.aws.ec2.model.TransitGatewayOptions.wrap(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGateway
  ): zio.aws.ec2.model.TransitGateway.ReadOnly = new Wrapper(impl)
}
