package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TargetConfiguration(
    instanceCount: Option[Integer] = None,
    offeringId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TargetConfiguration = {
    import TargetConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TargetConfiguration
      .builder()
      .optionallyWith(
        instanceCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.instanceCount)
      .optionallyWith(offeringId.map(value => value: java.lang.String))(
        _.offeringId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TargetConfiguration.ReadOnly =
    zio.aws.ec2.model.TargetConfiguration.wrap(buildAwsValue())
}
object TargetConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TargetConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TargetConfiguration =
      zio.aws.ec2.model.TargetConfiguration(
        instanceCount.map(value => value),
        offeringId.map(value => value)
      )
    def instanceCount: Option[Integer]
    def offeringId: Option[String]
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringId", offeringId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TargetConfiguration
  ) extends zio.aws.ec2.model.TargetConfiguration.ReadOnly {
    override val instanceCount: Option[Integer] = scala
      .Option(impl.instanceCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val offeringId: Option[String] =
      scala.Option(impl.offeringId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TargetConfiguration
  ): zio.aws.ec2.model.TargetConfiguration.ReadOnly = new Wrapper(impl)
}
