package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartNetworkInsightsAnalysisResponse(
    networkInsightsAnalysis: Option[zio.aws.ec2.model.NetworkInsightsAnalysis] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAnalysisResponse = {
    import StartNetworkInsightsAnalysisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAnalysisResponse
      .builder()
      .optionallyWith(
        networkInsightsAnalysis.map(value => value.buildAwsValue())
      )(_.networkInsightsAnalysis)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.StartNetworkInsightsAnalysisResponse.ReadOnly =
    zio.aws.ec2.model.StartNetworkInsightsAnalysisResponse.wrap(buildAwsValue())
}
object StartNetworkInsightsAnalysisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAnalysisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.StartNetworkInsightsAnalysisResponse =
      zio.aws.ec2.model.StartNetworkInsightsAnalysisResponse(
        networkInsightsAnalysis.map(value => value.asEditable)
      )
    def networkInsightsAnalysis
        : Option[zio.aws.ec2.model.NetworkInsightsAnalysis.ReadOnly]
    def getNetworkInsightsAnalysis: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInsightsAnalysis.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkInsightsAnalysis",
      networkInsightsAnalysis
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAnalysisResponse
  ) extends zio.aws.ec2.model.StartNetworkInsightsAnalysisResponse.ReadOnly {
    override val networkInsightsAnalysis
        : Option[zio.aws.ec2.model.NetworkInsightsAnalysis.ReadOnly] = scala
      .Option(impl.networkInsightsAnalysis())
      .map(value => zio.aws.ec2.model.NetworkInsightsAnalysis.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAnalysisResponse
  ): zio.aws.ec2.model.StartNetworkInsightsAnalysisResponse.ReadOnly =
    new Wrapper(impl)
}
