package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SpotDatafeedSubscription(
    bucket: Option[String] = None,
    fault: Option[zio.aws.ec2.model.SpotInstanceStateFault] = None,
    ownerId: Option[String] = None,
    prefix: Option[String] = None,
    state: Option[zio.aws.ec2.model.DatafeedSubscriptionState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotDatafeedSubscription = {
    import SpotDatafeedSubscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotDatafeedSubscription
      .builder()
      .optionallyWith(bucket.map(value => value: java.lang.String))(_.bucket)
      .optionallyWith(fault.map(value => value.buildAwsValue()))(_.fault)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotDatafeedSubscription.ReadOnly =
    zio.aws.ec2.model.SpotDatafeedSubscription.wrap(buildAwsValue())
}
object SpotDatafeedSubscription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotDatafeedSubscription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotDatafeedSubscription =
      zio.aws.ec2.model.SpotDatafeedSubscription(
        bucket.map(value => value),
        fault.map(value => value.asEditable),
        ownerId.map(value => value),
        prefix.map(value => value),
        state.map(value => value)
      )
    def bucket: Option[String]
    def fault: Option[zio.aws.ec2.model.SpotInstanceStateFault.ReadOnly]
    def ownerId: Option[String]
    def prefix: Option[String]
    def state: Option[zio.aws.ec2.model.DatafeedSubscriptionState]
    def getBucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getFault: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.SpotInstanceStateFault.ReadOnly
    ] = AwsError.unwrapOptionField("fault", fault)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.DatafeedSubscriptionState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotDatafeedSubscription
  ) extends zio.aws.ec2.model.SpotDatafeedSubscription.ReadOnly {
    override val bucket: Option[String] =
      scala.Option(impl.bucket()).map(value => value: String)
    override val fault
        : Option[zio.aws.ec2.model.SpotInstanceStateFault.ReadOnly] = scala
      .Option(impl.fault())
      .map(value => zio.aws.ec2.model.SpotInstanceStateFault.wrap(value))
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val prefix: Option[String] =
      scala.Option(impl.prefix()).map(value => value: String)
    override val state: Option[zio.aws.ec2.model.DatafeedSubscriptionState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.ec2.model.DatafeedSubscriptionState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotDatafeedSubscription
  ): zio.aws.ec2.model.SpotDatafeedSubscription.ReadOnly = new Wrapper(impl)
}
