package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait RouteState {
  def unwrap: software.amazon.awssdk.services.ec2.model.RouteState
}
object RouteState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.RouteState
  ): zio.aws.ec2.model.RouteState = value match {
    case software.amazon.awssdk.services.ec2.model.RouteState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.RouteState.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.ec2.model.RouteState.BLACKHOLE =>
      val r = blackhole
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.RouteState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.RouteState =
      software.amazon.awssdk.services.ec2.model.RouteState.UNKNOWN_TO_SDK_VERSION
  }
  case object active extends zio.aws.ec2.model.RouteState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.RouteState =
      software.amazon.awssdk.services.ec2.model.RouteState.ACTIVE
  }
  case object blackhole extends zio.aws.ec2.model.RouteState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.RouteState =
      software.amazon.awssdk.services.ec2.model.RouteState.BLACKHOLE
  }
}
