package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  IntegerWithConstraints,
  DoubleWithConstraints
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReservationFleetInstanceSpecification(
    instanceType: Option[zio.aws.ec2.model.InstanceType] = None,
    instancePlatform: Option[
      zio.aws.ec2.model.CapacityReservationInstancePlatform
    ] = None,
    weight: Option[DoubleWithConstraints] = None,
    availabilityZone: Option[String] = None,
    availabilityZoneId: Option[String] = None,
    ebsOptimized: Option[Boolean] = None,
    priority: Option[IntegerWithConstraints] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReservationFleetInstanceSpecification = {
    import ReservationFleetInstanceSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReservationFleetInstanceSpecification
      .builder()
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(instancePlatform.map(value => value.unwrap))(
        _.instancePlatform
      )
      .optionallyWith(
        weight.map(value =>
          DoubleWithConstraints.unwrap(value): java.lang.Double
        )
      )(_.weight)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(availabilityZoneId.map(value => value: java.lang.String))(
        _.availabilityZoneId
      )
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(
        priority.map(value => IntegerWithConstraints.unwrap(value): Integer)
      )(_.priority)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ReservationFleetInstanceSpecification.ReadOnly =
    zio.aws.ec2.model.ReservationFleetInstanceSpecification
      .wrap(buildAwsValue())
}
object ReservationFleetInstanceSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReservationFleetInstanceSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReservationFleetInstanceSpecification =
      zio.aws.ec2.model.ReservationFleetInstanceSpecification(
        instanceType.map(value => value),
        instancePlatform.map(value => value),
        weight.map(value => value),
        availabilityZone.map(value => value),
        availabilityZoneId.map(value => value),
        ebsOptimized.map(value => value),
        priority.map(value => value)
      )
    def instanceType: Option[zio.aws.ec2.model.InstanceType]
    def instancePlatform
        : Option[zio.aws.ec2.model.CapacityReservationInstancePlatform]
    def weight: Option[DoubleWithConstraints]
    def availabilityZone: Option[String]
    def availabilityZoneId: Option[String]
    def ebsOptimized: Option[Boolean]
    def priority: Option[IntegerWithConstraints]
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstancePlatform: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CapacityReservationInstancePlatform
    ] = AwsError.unwrapOptionField("instancePlatform", instancePlatform)
    def getWeight: ZIO[Any, AwsError, DoubleWithConstraints] =
      AwsError.unwrapOptionField("weight", weight)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAvailabilityZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getPriority: ZIO[Any, AwsError, IntegerWithConstraints] =
      AwsError.unwrapOptionField("priority", priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReservationFleetInstanceSpecification
  ) extends zio.aws.ec2.model.ReservationFleetInstanceSpecification.ReadOnly {
    override val instanceType: Option[zio.aws.ec2.model.InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val instancePlatform
        : Option[zio.aws.ec2.model.CapacityReservationInstancePlatform] = scala
      .Option(impl.instancePlatform())
      .map(value =>
        zio.aws.ec2.model.CapacityReservationInstancePlatform.wrap(value)
      )
    override val weight: Option[DoubleWithConstraints] = scala
      .Option(impl.weight())
      .map(value => zio.aws.ec2.model.primitives.DoubleWithConstraints(value))
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val availabilityZoneId: Option[String] =
      scala.Option(impl.availabilityZoneId()).map(value => value: String)
    override val ebsOptimized: Option[Boolean] =
      scala.Option(impl.ebsOptimized()).map(value => value: Boolean)
    override val priority: Option[IntegerWithConstraints] = scala
      .Option(impl.priority())
      .map(value => zio.aws.ec2.model.primitives.IntegerWithConstraints(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReservationFleetInstanceSpecification
  ): zio.aws.ec2.model.ReservationFleetInstanceSpecification.ReadOnly =
    new Wrapper(impl)
}
