package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait PermissionGroup {
  def unwrap: software.amazon.awssdk.services.ec2.model.PermissionGroup
}
object PermissionGroup {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.PermissionGroup
  ): zio.aws.ec2.model.PermissionGroup = value match {
    case software.amazon.awssdk.services.ec2.model.PermissionGroup.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.PermissionGroup.ALL =>
      val r = all
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.PermissionGroup {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PermissionGroup =
      software.amazon.awssdk.services.ec2.model.PermissionGroup.UNKNOWN_TO_SDK_VERSION
  }
  case object all extends zio.aws.ec2.model.PermissionGroup {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PermissionGroup =
      software.amazon.awssdk.services.ec2.model.PermissionGroup.ALL
  }
}
