package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  InstanceEventWindowCronExpression,
  InstanceEventWindowId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyInstanceEventWindowRequest(
    name: Option[String] = None,
    instanceEventWindowId: InstanceEventWindowId,
    timeRanges: Option[
      Iterable[zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest]
    ] = None,
    cronExpression: Option[InstanceEventWindowCronExpression] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyInstanceEventWindowRequest = {
    import ModifyInstanceEventWindowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyInstanceEventWindowRequest
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .instanceEventWindowId(
        InstanceEventWindowId.unwrap(instanceEventWindowId): java.lang.String
      )
      .optionallyWith(
        timeRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.timeRanges)
      .optionallyWith(
        cronExpression.map(value =>
          InstanceEventWindowCronExpression.unwrap(value): java.lang.String
        )
      )(_.cronExpression)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyInstanceEventWindowRequest.ReadOnly =
    zio.aws.ec2.model.ModifyInstanceEventWindowRequest.wrap(buildAwsValue())
}
object ModifyInstanceEventWindowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyInstanceEventWindowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyInstanceEventWindowRequest =
      zio.aws.ec2.model.ModifyInstanceEventWindowRequest(
        name.map(value => value),
        instanceEventWindowId,
        timeRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cronExpression.map(value => value)
      )
    def name: Option[String]
    def instanceEventWindowId: InstanceEventWindowId
    def timeRanges: Option[
      List[zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.ReadOnly]
    ]
    def cronExpression: Option[InstanceEventWindowCronExpression]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getInstanceEventWindowId: ZIO[Any, Nothing, InstanceEventWindowId] =
      ZIO.succeed(instanceEventWindowId)
    def getTimeRanges: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("timeRanges", timeRanges)
    def getCronExpression
        : ZIO[Any, AwsError, InstanceEventWindowCronExpression] =
      AwsError.unwrapOptionField("cronExpression", cronExpression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceEventWindowRequest
  ) extends zio.aws.ec2.model.ModifyInstanceEventWindowRequest.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val instanceEventWindowId: InstanceEventWindowId =
      zio.aws.ec2.model.primitives
        .InstanceEventWindowId(impl.instanceEventWindowId())
    override val timeRanges: Option[
      List[zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.ReadOnly]
    ] = scala
      .Option(impl.timeRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.wrap(item)
        }.toList
      )
    override val cronExpression: Option[InstanceEventWindowCronExpression] =
      scala
        .Option(impl.cronExpression())
        .map(value =>
          zio.aws.ec2.model.primitives.InstanceEventWindowCronExpression(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceEventWindowRequest
  ): zio.aws.ec2.model.ModifyInstanceEventWindowRequest.ReadOnly = new Wrapper(
    impl
  )
}
