package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyInstanceEventStartTimeResponse(
    event: Option[zio.aws.ec2.model.InstanceStatusEvent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeResponse = {
    import ModifyInstanceEventStartTimeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeResponse
      .builder()
      .optionallyWith(event.map(value => value.buildAwsValue()))(_.event)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyInstanceEventStartTimeResponse.ReadOnly =
    zio.aws.ec2.model.ModifyInstanceEventStartTimeResponse.wrap(buildAwsValue())
}
object ModifyInstanceEventStartTimeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyInstanceEventStartTimeResponse =
      zio.aws.ec2.model.ModifyInstanceEventStartTimeResponse(
        event.map(value => value.asEditable)
      )
    def event: Option[zio.aws.ec2.model.InstanceStatusEvent.ReadOnly]
    def getEvent
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceStatusEvent.ReadOnly] =
      AwsError.unwrapOptionField("event", event)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeResponse
  ) extends zio.aws.ec2.model.ModifyInstanceEventStartTimeResponse.ReadOnly {
    override val event: Option[zio.aws.ec2.model.InstanceStatusEvent.ReadOnly] =
      scala
        .Option(impl.event())
        .map(value => zio.aws.ec2.model.InstanceStatusEvent.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeResponse
  ): zio.aws.ec2.model.ModifyInstanceEventStartTimeResponse.ReadOnly =
    new Wrapper(impl)
}
