package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoadPermissionModifications(
    add: Option[Iterable[zio.aws.ec2.model.LoadPermissionRequest]] = None,
    remove: Option[Iterable[zio.aws.ec2.model.LoadPermissionRequest]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LoadPermissionModifications = {
    import LoadPermissionModifications.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LoadPermissionModifications
      .builder()
      .optionallyWith(
        add.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.add)
      .optionallyWith(
        remove.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.remove)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LoadPermissionModifications.ReadOnly =
    zio.aws.ec2.model.LoadPermissionModifications.wrap(buildAwsValue())
}
object LoadPermissionModifications {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LoadPermissionModifications
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LoadPermissionModifications =
      zio.aws.ec2.model.LoadPermissionModifications(
        add.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        remove.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def add: Option[List[zio.aws.ec2.model.LoadPermissionRequest.ReadOnly]]
    def remove: Option[List[zio.aws.ec2.model.LoadPermissionRequest.ReadOnly]]
    def getAdd: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LoadPermissionRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("add", add)
    def getRemove: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LoadPermissionRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("remove", remove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LoadPermissionModifications
  ) extends zio.aws.ec2.model.LoadPermissionModifications.ReadOnly {
    override val add
        : Option[List[zio.aws.ec2.model.LoadPermissionRequest.ReadOnly]] = scala
      .Option(impl.add())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LoadPermissionRequest.wrap(item)
        }.toList
      )
    override val remove
        : Option[List[zio.aws.ec2.model.LoadPermissionRequest.ReadOnly]] = scala
      .Option(impl.remove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LoadPermissionRequest.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LoadPermissionModifications
  ): zio.aws.ec2.model.LoadPermissionModifications.ReadOnly = new Wrapper(impl)
}
