package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  SnapshotId,
  ListSnapshotsInRecycleBinMaxResults
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListSnapshotsInRecycleBinRequest(
    maxResults: Option[ListSnapshotsInRecycleBinMaxResults] = None,
    nextToken: Option[String] = None,
    snapshotIds: Option[Iterable[SnapshotId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinRequest = {
    import ListSnapshotsInRecycleBinRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListSnapshotsInRecycleBinMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        snapshotIds.map(value =>
          value.map { item =>
            SnapshotId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.snapshotIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ListSnapshotsInRecycleBinRequest.ReadOnly =
    zio.aws.ec2.model.ListSnapshotsInRecycleBinRequest.wrap(buildAwsValue())
}
object ListSnapshotsInRecycleBinRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ListSnapshotsInRecycleBinRequest =
      zio.aws.ec2.model.ListSnapshotsInRecycleBinRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        snapshotIds.map(value => value)
      )
    def maxResults: Option[ListSnapshotsInRecycleBinMaxResults]
    def nextToken: Option[String]
    def snapshotIds: Option[List[SnapshotId]]
    def getMaxResults: ZIO[Any, AwsError, ListSnapshotsInRecycleBinMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSnapshotIds: ZIO[Any, AwsError, List[SnapshotId]] =
      AwsError.unwrapOptionField("snapshotIds", snapshotIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinRequest
  ) extends zio.aws.ec2.model.ListSnapshotsInRecycleBinRequest.ReadOnly {
    override val maxResults: Option[ListSnapshotsInRecycleBinMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.ListSnapshotsInRecycleBinMaxResults(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val snapshotIds: Option[List[SnapshotId]] = scala
      .Option(impl.snapshotIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SnapshotId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinRequest
  ): zio.aws.ec2.model.ListSnapshotsInRecycleBinRequest.ReadOnly = new Wrapper(
    impl
  )
}
