package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchSpecification(
    userData: Option[String] = None,
    securityGroups: Option[Iterable[zio.aws.ec2.model.GroupIdentifier]] = None,
    addressingType: Option[String] = None,
    blockDeviceMappings: Option[
      Iterable[zio.aws.ec2.model.BlockDeviceMapping]
    ] = None,
    ebsOptimized: Option[Boolean] = None,
    iamInstanceProfile: Option[
      zio.aws.ec2.model.IamInstanceProfileSpecification
    ] = None,
    imageId: Option[String] = None,
    instanceType: Option[zio.aws.ec2.model.InstanceType] = None,
    kernelId: Option[String] = None,
    keyName: Option[String] = None,
    networkInterfaces: Option[
      Iterable[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification]
    ] = None,
    placement: Option[zio.aws.ec2.model.SpotPlacement] = None,
    ramdiskId: Option[String] = None,
    subnetId: Option[String] = None,
    monitoring: Option[zio.aws.ec2.model.RunInstancesMonitoringEnabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchSpecification = {
    import LaunchSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchSpecification
      .builder()
      .optionallyWith(userData.map(value => value: java.lang.String))(
        _.userData
      )
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(addressingType.map(value => value: java.lang.String))(
        _.addressingType
      )
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(kernelId.map(value => value: java.lang.String))(
        _.kernelId
      )
      .optionallyWith(keyName.map(value => value: java.lang.String))(_.keyName)
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(ramdiskId.map(value => value: java.lang.String))(
        _.ramdiskId
      )
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(monitoring.map(value => value.buildAwsValue()))(
        _.monitoring
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LaunchSpecification.ReadOnly =
    zio.aws.ec2.model.LaunchSpecification.wrap(buildAwsValue())
}
object LaunchSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchSpecification =
      zio.aws.ec2.model.LaunchSpecification(
        userData.map(value => value),
        securityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        addressingType.map(value => value),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ebsOptimized.map(value => value),
        iamInstanceProfile.map(value => value.asEditable),
        imageId.map(value => value),
        instanceType.map(value => value),
        kernelId.map(value => value),
        keyName.map(value => value),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placement.map(value => value.asEditable),
        ramdiskId.map(value => value),
        subnetId.map(value => value),
        monitoring.map(value => value.asEditable)
      )
    def userData: Option[String]
    def securityGroups: Option[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]]
    def addressingType: Option[String]
    def blockDeviceMappings
        : Option[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]]
    def ebsOptimized: Option[Boolean]
    def iamInstanceProfile
        : Option[zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly]
    def imageId: Option[String]
    def instanceType: Option[zio.aws.ec2.model.InstanceType]
    def kernelId: Option[String]
    def keyName: Option[String]
    def networkInterfaces: Option[
      List[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly]
    ]
    def placement: Option[zio.aws.ec2.model.SpotPlacement.ReadOnly]
    def ramdiskId: Option[String]
    def subnetId: Option[String]
    def monitoring
        : Option[zio.aws.ec2.model.RunInstancesMonitoringEnabled.ReadOnly]
    def getUserData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userData", userData)
    def getSecurityGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getAddressingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addressingType", addressingType)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.BlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getIamInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKernelId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getKeyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getPlacement
        : ZIO[Any, AwsError, zio.aws.ec2.model.SpotPlacement.ReadOnly] =
      AwsError.unwrapOptionField("placement", placement)
    def getRamdiskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getMonitoring: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.RunInstancesMonitoringEnabled.ReadOnly
    ] = AwsError.unwrapOptionField("monitoring", monitoring)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchSpecification
  ) extends zio.aws.ec2.model.LaunchSpecification.ReadOnly {
    override val userData: Option[String] =
      scala.Option(impl.userData()).map(value => value: String)
    override val securityGroups
        : Option[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.GroupIdentifier.wrap(item)
        }.toList
      )
    override val addressingType: Option[String] =
      scala.Option(impl.addressingType()).map(value => value: String)
    override val blockDeviceMappings
        : Option[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]] = scala
      .Option(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.BlockDeviceMapping.wrap(item)
        }.toList
      )
    override val ebsOptimized: Option[Boolean] =
      scala.Option(impl.ebsOptimized()).map(value => value: Boolean)
    override val iamInstanceProfile
        : Option[zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly] =
      scala
        .Option(impl.iamInstanceProfile())
        .map(value =>
          zio.aws.ec2.model.IamInstanceProfileSpecification.wrap(value)
        )
    override val imageId: Option[String] =
      scala.Option(impl.imageId()).map(value => value: String)
    override val instanceType: Option[zio.aws.ec2.model.InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val kernelId: Option[String] =
      scala.Option(impl.kernelId()).map(value => value: String)
    override val keyName: Option[String] =
      scala.Option(impl.keyName()).map(value => value: String)
    override val networkInterfaces: Option[
      List[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly]
    ] = scala
      .Option(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.wrap(item)
        }.toList
      )
    override val placement: Option[zio.aws.ec2.model.SpotPlacement.ReadOnly] =
      scala
        .Option(impl.placement())
        .map(value => zio.aws.ec2.model.SpotPlacement.wrap(value))
    override val ramdiskId: Option[String] =
      scala.Option(impl.ramdiskId()).map(value => value: String)
    override val subnetId: Option[String] =
      scala.Option(impl.subnetId()).map(value => value: String)
    override val monitoring
        : Option[zio.aws.ec2.model.RunInstancesMonitoringEnabled.ReadOnly] =
      scala
        .Option(impl.monitoring())
        .map(value =>
          zio.aws.ec2.model.RunInstancesMonitoringEnabled.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchSpecification
  ): zio.aws.ec2.model.LaunchSpecification.ReadOnly = new Wrapper(impl)
}
