package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait IpamAddressHistoryResourceType {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType
}
object IpamAddressHistoryResourceType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType
  ): zio.aws.ec2.model.IpamAddressHistoryResourceType = value match {
    case software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType.EIP =>
      val r = eip
      r
    case software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType.VPC =>
      val r = vpc
      r
    case software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType.SUBNET =>
      val r = subnet
      r
    case software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType.NETWORK_INTERFACE =>
      val r = `network-interface`
      r
    case software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType.INSTANCE =>
      val r = instance
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.IpamAddressHistoryResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType =
      software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object eip extends zio.aws.ec2.model.IpamAddressHistoryResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType =
      software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType.EIP
  }
  case object vpc extends zio.aws.ec2.model.IpamAddressHistoryResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType =
      software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType.VPC
  }
  case object subnet extends zio.aws.ec2.model.IpamAddressHistoryResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType =
      software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType.SUBNET
  }
  case object `network-interface`
      extends zio.aws.ec2.model.IpamAddressHistoryResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType =
      software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType.NETWORK_INTERFACE
  }
  case object instance
      extends zio.aws.ec2.model.IpamAddressHistoryResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType =
      software.amazon.awssdk.services.ec2.model.IpamAddressHistoryResourceType.INSTANCE
  }
}
