package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceCreditSpecificationRequest(
    instanceId: Option[InstanceId] = None,
    cpuCredits: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceCreditSpecificationRequest = {
    import InstanceCreditSpecificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceCreditSpecificationRequest
      .builder()
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(cpuCredits.map(value => value: java.lang.String))(
        _.cpuCredits
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.InstanceCreditSpecificationRequest.ReadOnly =
    zio.aws.ec2.model.InstanceCreditSpecificationRequest.wrap(buildAwsValue())
}
object InstanceCreditSpecificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceCreditSpecificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceCreditSpecificationRequest =
      zio.aws.ec2.model.InstanceCreditSpecificationRequest(
        instanceId.map(value => value),
        cpuCredits.map(value => value)
      )
    def instanceId: Option[InstanceId]
    def cpuCredits: Option[String]
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getCpuCredits: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cpuCredits", cpuCredits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceCreditSpecificationRequest
  ) extends zio.aws.ec2.model.InstanceCreditSpecificationRequest.ReadOnly {
    override val instanceId: Option[InstanceId] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.ec2.model.primitives.InstanceId(value))
    override val cpuCredits: Option[String] =
      scala.Option(impl.cpuCredits()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceCreditSpecificationRequest
  ): zio.aws.ec2.model.InstanceCreditSpecificationRequest.ReadOnly =
    new Wrapper(impl)
}
