package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportVolumeTaskDetails(
    availabilityZone: Option[String] = None,
    bytesConverted: Option[Long] = None,
    description: Option[String] = None,
    image: Option[zio.aws.ec2.model.DiskImageDescription] = None,
    volume: Option[zio.aws.ec2.model.DiskImageVolumeDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportVolumeTaskDetails = {
    import ImportVolumeTaskDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportVolumeTaskDetails
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(bytesConverted.map(value => value: java.lang.Long))(
        _.bytesConverted
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(image.map(value => value.buildAwsValue()))(_.image)
      .optionallyWith(volume.map(value => value.buildAwsValue()))(_.volume)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportVolumeTaskDetails.ReadOnly =
    zio.aws.ec2.model.ImportVolumeTaskDetails.wrap(buildAwsValue())
}
object ImportVolumeTaskDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportVolumeTaskDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportVolumeTaskDetails =
      zio.aws.ec2.model.ImportVolumeTaskDetails(
        availabilityZone.map(value => value),
        bytesConverted.map(value => value),
        description.map(value => value),
        image.map(value => value.asEditable),
        volume.map(value => value.asEditable)
      )
    def availabilityZone: Option[String]
    def bytesConverted: Option[Long]
    def description: Option[String]
    def image: Option[zio.aws.ec2.model.DiskImageDescription.ReadOnly]
    def volume: Option[zio.aws.ec2.model.DiskImageVolumeDescription.ReadOnly]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getBytesConverted: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("bytesConverted", bytesConverted)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getImage
        : ZIO[Any, AwsError, zio.aws.ec2.model.DiskImageDescription.ReadOnly] =
      AwsError.unwrapOptionField("image", image)
    def getVolume: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DiskImageVolumeDescription.ReadOnly
    ] = AwsError.unwrapOptionField("volume", volume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportVolumeTaskDetails
  ) extends zio.aws.ec2.model.ImportVolumeTaskDetails.ReadOnly {
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val bytesConverted: Option[Long] =
      scala.Option(impl.bytesConverted()).map(value => value: Long)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val image
        : Option[zio.aws.ec2.model.DiskImageDescription.ReadOnly] = scala
      .Option(impl.image())
      .map(value => zio.aws.ec2.model.DiskImageDescription.wrap(value))
    override val volume
        : Option[zio.aws.ec2.model.DiskImageVolumeDescription.ReadOnly] = scala
      .Option(impl.volume())
      .map(value => zio.aws.ec2.model.DiskImageVolumeDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportVolumeTaskDetails
  ): zio.aws.ec2.model.ImportVolumeTaskDetails.ReadOnly = new Wrapper(impl)
}
