package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportKeyPairResponse(
    keyFingerprint: Option[String] = None,
    keyName: Option[String] = None,
    keyPairId: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportKeyPairResponse = {
    import ImportKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportKeyPairResponse
      .builder()
      .optionallyWith(keyFingerprint.map(value => value: java.lang.String))(
        _.keyFingerprint
      )
      .optionallyWith(keyName.map(value => value: java.lang.String))(_.keyName)
      .optionallyWith(keyPairId.map(value => value: java.lang.String))(
        _.keyPairId
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportKeyPairResponse.ReadOnly =
    zio.aws.ec2.model.ImportKeyPairResponse.wrap(buildAwsValue())
}
object ImportKeyPairResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportKeyPairResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportKeyPairResponse =
      zio.aws.ec2.model.ImportKeyPairResponse(
        keyFingerprint.map(value => value),
        keyName.map(value => value),
        keyPairId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def keyFingerprint: Option[String]
    def keyName: Option[String]
    def keyPairId: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getKeyFingerprint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyFingerprint", keyFingerprint)
    def getKeyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getKeyPairId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyPairId", keyPairId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportKeyPairResponse
  ) extends zio.aws.ec2.model.ImportKeyPairResponse.ReadOnly {
    override val keyFingerprint: Option[String] =
      scala.Option(impl.keyFingerprint()).map(value => value: String)
    override val keyName: Option[String] =
      scala.Option(impl.keyName()).map(value => value: String)
    override val keyPairId: Option[String] =
      scala.Option(impl.keyPairId()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportKeyPairResponse
  ): zio.aws.ec2.model.ImportKeyPairResponse.ReadOnly = new Wrapper(impl)
}
